/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.swt.animation;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Widget;

public class Animation {
	Object jsObject;
	Widget widget;
	int repeatCount = 1;
	long startDelay;
	boolean disposed;
	
	public static final int FOREVER = 0;

public Animation() {
}

void checkAnimation() {
	if (isDisposed()) SWT.error(SWT.ERROR_WIDGET_DISPOSED);
}

public void dispose() {
	if (isDisposed()) return;
	disposed = true;
	release();
}

void release() {
	widget = null;
}

public void setBeginTime(long beginTime) {
	checkAnimation();
	this.startDelay = beginTime;
}

public void setRepeatCount(int repeatCount) {
	checkAnimation();
	if (repeatCount == 0) SWT.error(SWT.ERROR_INVALID_ARGUMENT);
	this.repeatCount = repeatCount;
}

public void start(Widget widget) {
	checkAnimation();
	this.widget = widget;
	create ();
	_play();
}

void create() {
	//nothing here
}

public void stop() {
	checkAnimation();
	if (jsObject != null) _stop();
}

public boolean isDisposed() {
	return disposed;
}

native void _play() /*-{
	this.@org.eclipse.swt.animation.Animation::jsObject.play();
}-*/;

native void _stop() /*-{
	this.@org.eclipse.swt.animation.Animation::jsObject.stop(false);
}-*/;
}
